/**
* \file: info_messages.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AMS_IPC_INFO_MESSAGE_H
#define AMS_IPC_INFO_MESSAGE_H

#include "automounter_types.h"
#include "ipc/message_buffer.h"

typedef unsigned int event_mask_t;

typedef enum info_event_t
{
	PARTITION_UPDATE_INFO_EVENT	= 0x00000001,
	PARTITION_DETECTED_EVENT	= 0x00000002,
	PARTITION_UNSUPPORTED_EVENT = 0x00000004,
	PARTITION_MOUNTING_EVENT	= 0x00000008,
	PARTITION_MOUNTED_EVENT		= 0x00000010,
	PARTITION_MOUNT_ERR_EVENT	= 0x00000020,
	PARTITION_REMOUNTING_EVENT	= 0x00000040,
	PARTITION_UNMOUNTING_EVENT	= 0x00000080,
	PARTITION_UNMOUNTED_EVENT 	= 0x00000100,
	PARTITION_INVALID_EVENT		= 0x00000200,
	DEVICE_UPDATE_INFO_EVENT	= 0x00000400,
	DEVICE_DETECTED_EVENT		= 0x00000800,
	DEVICE_NOMEDIA_EVENT		= 0x00001000,
	DEVICE_AUTOMOUNTING_EVENT	= 0x00002000,
	DEVICE_AUTOMOUNTED_EVENT	= 0x00004000,
	DEVICE_UNMOUNTING_EVENT		= 0x00008000,
	DEVICE_UNMOUNTED_EVENT		= 0x00010000,
	DEVICE_INVALID_EVENT		= 0x00020000,
	SNAP_SHOT_DONE_EVENT	  	= 0x00040000
} info_event_t;

typedef struct partition_info_message_t
{
	info_event_t event;
	device_info_t device_info;
	partition_info_t part_info;
	int request_id;
} partition_info_message_t;

typedef struct device_info_message_t
{
	info_event_t event;
	device_info_t device_info;
	int request_id;
} device_info_message_t;

error_code_t info_messages_prepare_part_info_msg(message_buffer_t *msg_buffer, info_event_t event,
		const device_info_t *dev_info, const partition_info_t *part_info, int request_id);

error_code_t info_messages_extract_part_info_msg(message_buffer_t *msg_buffer,
		partition_info_message_t **msg_ptr);

error_code_t info_messages_prepare_dev_info_msg(message_buffer_t *msg_buffer, info_event_t event,
		const device_info_t *dev_info, int request_id);

error_code_t info_messages_extract_dev_info_msg(message_buffer_t *msg_buffer,
		device_info_message_t **msg_ptr);

error_code_t request_message_prepare_appinfo_msg(message_buffer_t *msg_buffer, const char *app_identifier,
		event_mask_t event_mask);

error_code_t request_message_extract_appinfo_msg(message_buffer_t *msg_buffer,
		const char **app_identifier_ptr,event_mask_t **event_mask_ptr);

#endif
